-- phpMyAdmin SQL Dump
-- version 4.4.4
-- http://www.phpmyadmin.net
--
-- Počítač: innodb.endora.cz:3306
-- Vytvořeno: Čtv 07. dub 2016, 10:20
-- Verze serveru: 5.6.28-76.1
-- Verze PHP: 5.4.42

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Databáze: `poznamwebsurvey`
--

-- --------------------------------------------------------

--
-- Struktura tabulky `category`
--

CREATE TABLE IF NOT EXISTS `category` (
  `id_category` int(11) NOT NULL,
  `id_parent` int(11) DEFAULT NULL,
  `name` varchar(45) COLLATE utf8_czech_ci DEFAULT NULL,
  `label` text COLLATE utf8_czech_ci,
  `order` int(11) DEFAULT NULL,
  `child_label` text COLLATE utf8_czech_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `code`
--

CREATE TABLE IF NOT EXISTS `code` (
  `id_code` int(11) NOT NULL,
  `code` varchar(20) COLLATE utf8_czech_ci NOT NULL,
  `url` varchar(50) COLLATE utf8_czech_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `entity_category`
--

CREATE TABLE IF NOT EXISTS `entity_category` (
  `id_entity_category` int(11) NOT NULL,
  `id_category` int(11) NOT NULL,
  `id_website` int(11) DEFAULT NULL,
  `id_respondent` int(11) DEFAULT NULL,
  `period` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `page`
--

CREATE TABLE IF NOT EXISTS `page` (
  `id_page` int(11) NOT NULL,
  `id_website` int(11) NOT NULL,
  `name` varchar(45) COLLATE utf8_czech_ci NOT NULL,
  `url` text COLLATE utf8_czech_ci NOT NULL,
  `dominant_color` varchar(45) COLLATE utf8_czech_ci DEFAULT NULL,
  `dominant_text_color` varchar(45) COLLATE utf8_czech_ci DEFAULT NULL,
  `priority` tinyint(1) NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `page_related`
--

CREATE TABLE IF NOT EXISTS `page_related` (
  `id_page_related` int(11) NOT NULL,
  `id_page_a` int(11) NOT NULL,
  `id_page_b` int(11) NOT NULL,
  `duel` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `question`
--

CREATE TABLE IF NOT EXISTS `question` (
  `id_question` int(11) NOT NULL,
  `id_respondent` int(11) DEFAULT NULL,
  `id_page` int(11) NOT NULL,
  `datetime` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `respondent`
--

CREATE TABLE IF NOT EXISTS `respondent` (
  `id_respondent` int(11) NOT NULL,
  `nickname` varchar(255) COLLATE utf8_czech_ci DEFAULT NULL,
  `age` varchar(5) COLLATE utf8_czech_ci DEFAULT NULL,
  `gender` varchar(1) COLLATE utf8_czech_ci DEFAULT NULL,
  `english` tinyint(1) DEFAULT NULL,
  `it` tinyint(1) DEFAULT NULL,
  `device_computer` tinyint(1) DEFAULT NULL,
  `device_tablet` tinyint(1) DEFAULT NULL,
  `device_phone` tinyint(1) DEFAULT NULL,
  `device_most` varchar(1) COLLATE utf8_czech_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_czech_ci DEFAULT NULL,
  `message` text COLLATE utf8_czech_ci,
  `sites` text COLLATE utf8_czech_ci,
  `datetime` datetime DEFAULT NULL,
  `user_agent` text COLLATE utf8_czech_ci,
  `code` varchar(20) COLLATE utf8_czech_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `respondent_page_duel`
--

CREATE TABLE IF NOT EXISTS `respondent_page_duel` (
  `id_respondent_page_duel` int(11) NOT NULL,
  `id_respondent` int(11) NOT NULL,
  `id_page_related` int(11) NOT NULL,
  `more_often` varchar(1) COLLATE utf8_czech_ci NOT NULL,
  `id_page` int(11) DEFAULT NULL,
  `datetime` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `respondent_website`
--

CREATE TABLE IF NOT EXISTS `respondent_website` (
  `id_respondent_website` int(11) NOT NULL,
  `id_respondent` int(11) NOT NULL,
  `id_website` int(11) NOT NULL,
  `period` int(11) NOT NULL,
  `datetime` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `subquestion`
--

CREATE TABLE IF NOT EXISTS `subquestion` (
  `id_subquestion` int(11) NOT NULL,
  `id_question` int(11) NOT NULL,
  `id_wireframe` varchar(45) COLLATE utf8_czech_ci DEFAULT NULL,
  `question_type` int(11) NOT NULL,
  `answer` varchar(500) COLLATE utf8_czech_ci DEFAULT NULL,
  `state` tinyint(1) DEFAULT NULL COMMENT '0 - ne 1 - ano 2 - temer 3 - nepocitane null - neovereno',
  `reason` text COLLATE utf8_czech_ci,
  `seconds` int(11) DEFAULT NULL,
  `datetime` datetime DEFAULT NULL,
  `id_page_related` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `user`
--

CREATE TABLE IF NOT EXISTS `user` (
  `id_user` int(11) NOT NULL,
  `login` varchar(50) COLLATE utf8_czech_ci NOT NULL,
  `password` text COLLATE utf8_czech_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `website`
--

CREATE TABLE IF NOT EXISTS `website` (
  `id_website` int(11) NOT NULL,
  `name` varchar(45) COLLATE utf8_czech_ci NOT NULL,
  `url` varchar(45) COLLATE utf8_czech_ci NOT NULL,
  `language` varchar(2) COLLATE utf8_czech_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `wireframe`
--

CREATE TABLE IF NOT EXISTS `wireframe` (
  `id_wireframe` int(11) NOT NULL,
  `id_page` int(11) NOT NULL,
  `text_mode` varchar(45) COLLATE utf8_czech_ci NOT NULL,
  `image_mode` varchar(45) COLLATE utf8_czech_ci NOT NULL,
  `resolution_width` int(11) NOT NULL,
  `resolution_height` int(11) NOT NULL,
  `device` varchar(45) COLLATE utf8_czech_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Klíče pro exportované tabulky
--

--
-- Klíče pro tabulku `category`
--
ALTER TABLE `category`
  ADD PRIMARY KEY (`id_category`);

--
-- Klíče pro tabulku `code`
--
ALTER TABLE `code`
  ADD PRIMARY KEY (`id_code`);

--
-- Klíče pro tabulku `entity_category`
--
ALTER TABLE `entity_category`
  ADD PRIMARY KEY (`id_entity_category`),
  ADD KEY `id_category` (`id_category`),
  ADD KEY `id_website` (`id_website`),
  ADD KEY `id_respondent` (`id_respondent`);

--
-- Klíče pro tabulku `page`
--
ALTER TABLE `page`
  ADD PRIMARY KEY (`id_page`),
  ADD KEY `id_website_idx` (`id_website`);

--
-- Klíče pro tabulku `page_related`
--
ALTER TABLE `page_related`
  ADD PRIMARY KEY (`id_page_related`),
  ADD KEY `id_page_a` (`id_page_a`),
  ADD KEY `id_page_b` (`id_page_b`);

--
-- Klíče pro tabulku `question`
--
ALTER TABLE `question`
  ADD PRIMARY KEY (`id_question`),
  ADD KEY `id_respondent` (`id_respondent`),
  ADD KEY `id_page` (`id_page`);

--
-- Klíče pro tabulku `respondent`
--
ALTER TABLE `respondent`
  ADD PRIMARY KEY (`id_respondent`);

--
-- Klíče pro tabulku `respondent_page_duel`
--
ALTER TABLE `respondent_page_duel`
  ADD PRIMARY KEY (`id_respondent_page_duel`),
  ADD KEY `id_respondent` (`id_respondent`),
  ADD KEY `id_page_related` (`id_page_related`),
  ADD KEY `id_page` (`id_page`);

--
-- Klíče pro tabulku `respondent_website`
--
ALTER TABLE `respondent_website`
  ADD PRIMARY KEY (`id_respondent_website`),
  ADD KEY `id_respondent` (`id_respondent`),
  ADD KEY `id_website` (`id_website`);

--
-- Klíče pro tabulku `subquestion`
--
ALTER TABLE `subquestion`
  ADD PRIMARY KEY (`id_subquestion`),
  ADD KEY `id_question_idx` (`id_question`),
  ADD KEY `id_page_related` (`id_page_related`);

--
-- Klíče pro tabulku `user`
--
ALTER TABLE `user`
  ADD PRIMARY KEY (`id_user`);

--
-- Klíče pro tabulku `website`
--
ALTER TABLE `website`
  ADD PRIMARY KEY (`id_website`),
  ADD UNIQUE KEY `url_UNIQUE` (`url`);

--
-- Klíče pro tabulku `wireframe`
--
ALTER TABLE `wireframe`
  ADD PRIMARY KEY (`id_wireframe`),
  ADD KEY `id_page_idx` (`id_page`);

--
-- AUTO_INCREMENT pro tabulky
--

--
-- AUTO_INCREMENT pro tabulku `category`
--
ALTER TABLE `category`
  MODIFY `id_category` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `code`
--
ALTER TABLE `code`
  MODIFY `id_code` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `entity_category`
--
ALTER TABLE `entity_category`
  MODIFY `id_entity_category` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `page`
--
ALTER TABLE `page`
  MODIFY `id_page` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `page_related`
--
ALTER TABLE `page_related`
  MODIFY `id_page_related` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `question`
--
ALTER TABLE `question`
  MODIFY `id_question` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `respondent`
--
ALTER TABLE `respondent`
  MODIFY `id_respondent` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `respondent_page_duel`
--
ALTER TABLE `respondent_page_duel`
  MODIFY `id_respondent_page_duel` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `respondent_website`
--
ALTER TABLE `respondent_website`
  MODIFY `id_respondent_website` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `subquestion`
--
ALTER TABLE `subquestion`
  MODIFY `id_subquestion` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `user`
--
ALTER TABLE `user`
  MODIFY `id_user` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `website`
--
ALTER TABLE `website`
  MODIFY `id_website` int(11) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT pro tabulku `wireframe`
--
ALTER TABLE `wireframe`
  MODIFY `id_wireframe` int(11) NOT NULL AUTO_INCREMENT;
--
-- Omezení pro exportované tabulky
--

--
-- Omezení pro tabulku `entity_category`
--
ALTER TABLE `entity_category`
  ADD CONSTRAINT `entity_category_ibfk_1` FOREIGN KEY (`id_category`) REFERENCES `category` (`id_category`),
  ADD CONSTRAINT `entity_category_ibfk_2` FOREIGN KEY (`id_website`) REFERENCES `website` (`id_website`),
  ADD CONSTRAINT `entity_category_ibfk_3` FOREIGN KEY (`id_respondent`) REFERENCES `respondent` (`id_respondent`);

--
-- Omezení pro tabulku `page`
--
ALTER TABLE `page`
  ADD CONSTRAINT `id_website` FOREIGN KEY (`id_website`) REFERENCES `website` (`id_website`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Omezení pro tabulku `page_related`
--
ALTER TABLE `page_related`
  ADD CONSTRAINT `page_related_ibfk_1` FOREIGN KEY (`id_page_a`) REFERENCES `page` (`id_page`),
  ADD CONSTRAINT `page_related_ibfk_2` FOREIGN KEY (`id_page_b`) REFERENCES `page` (`id_page`);

--
-- Omezení pro tabulku `question`
--
ALTER TABLE `question`
  ADD CONSTRAINT `question_ibfk_1` FOREIGN KEY (`id_respondent`) REFERENCES `respondent` (`id_respondent`),
  ADD CONSTRAINT `question_ibfk_2` FOREIGN KEY (`id_page`) REFERENCES `page` (`id_page`);

--
-- Omezení pro tabulku `respondent_page_duel`
--
ALTER TABLE `respondent_page_duel`
  ADD CONSTRAINT `respondent_page_duel_ibfk_1` FOREIGN KEY (`id_respondent`) REFERENCES `respondent` (`id_respondent`),
  ADD CONSTRAINT `respondent_page_duel_ibfk_2` FOREIGN KEY (`id_page_related`) REFERENCES `page_related` (`id_page_related`),
  ADD CONSTRAINT `respondent_page_duel_ibfk_3` FOREIGN KEY (`id_page`) REFERENCES `page` (`id_page`);

--
-- Omezení pro tabulku `respondent_website`
--
ALTER TABLE `respondent_website`
  ADD CONSTRAINT `respondent_website_ibfk_1` FOREIGN KEY (`id_respondent`) REFERENCES `respondent` (`id_respondent`),
  ADD CONSTRAINT `respondent_website_ibfk_2` FOREIGN KEY (`id_website`) REFERENCES `website` (`id_website`);

--
-- Omezení pro tabulku `subquestion`
--
ALTER TABLE `subquestion`
  ADD CONSTRAINT `id_question` FOREIGN KEY (`id_question`) REFERENCES `question` (`id_question`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `subquestion_ibfk_1` FOREIGN KEY (`id_page_related`) REFERENCES `page_related` (`id_page_related`);

--
-- Omezení pro tabulku `wireframe`
--
ALTER TABLE `wireframe`
  ADD CONSTRAINT `id_page` FOREIGN KEY (`id_page`) REFERENCES `page` (`id_page`) ON DELETE NO ACTION ON UPDATE NO ACTION;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
